/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.init;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.commons.io.filefilter.FileFilterUtils;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.json.ChickenData;
import wallywhip.resourcechickens.json.ChickenDataSerializer;

public class initChickenConfigs {
    private static Path MOD_ROOT;

    public static void loadConfigs() {
        Optional mod = FabricLoader.getInstance().getModContainer("resourcechickens");
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            mod.ifPresent(modContainer -> {
                MOD_ROOT = (Path)modContainer.getRootPaths().get(0);
            });
        } else {
            mod.ifPresent(modContainer -> {
                MOD_ROOT = FabricLoader.getInstance().getConfigDir().getParent().resolve("mods/" + modContainer.getMetadata().getId() + "-" + modContainer.getMetadata().getVersion() + ".jar");
            });
        }
        Path dir = FabricLoader.getInstance().getConfigDir().resolve("resourcechickens");
        if (!Files.exists(dir, new LinkOption[0]) && dir.toFile().mkdir()) {
            initChickenConfigs.copyDefaultConfigs("/data/resourcechickens/configs/vanilla", dir.resolve("vanilla"));
            initChickenConfigs.copyDefaultConfigs("/data/resourcechickens/configs/modded", dir.resolve("modded"));
        }
        initChickenConfigs.loadChickenConfigs(dir, "vanilla");
        initChickenConfigs.loadChickenConfigs(dir, "modded");
        initChickenConfigs.loadChickenConfigs(dir, "custom");
    }

    private static void loadChickenConfigs(Path root, String folder) {
        File[] files = root.resolve(folder).toFile().listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (files == null) {
            return;
        }
        Gson gson = ChickenDataSerializer.initGson();
        for (File file : files) {
            try {
                FileReader reader = new FileReader(file);
                ChickenData chickenData = (ChickenData)gson.fromJson((Reader)reader, ChickenData.class);
                reader.close();
                if (!chickenData.enabled) continue;
                chickenData.ID = file.getName();
                chickenData.ID = chickenData.ID.substring(0, chickenData.ID.length() - 5);
                initChickenRegistry.registerChicken(chickenData);
                chickenData.chickenTexture = new class_2960("resourcechickens:textures/entity/" + folder + "/" + chickenData.ID + ".png");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void copyDefaultConfigs(String dataPath, Path targetPath) {
        if (!Files.exists(targetPath, new LinkOption[0])) {
            targetPath.toFile().mkdir();
        }
        if (Files.isRegularFile(MOD_ROOT, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(MOD_ROOT, (ClassLoader)null);){
                Path path = fileSystem.getPath(dataPath, new String[0]);
                initChickenConfigs.copyFiles(path, targetPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (Files.isDirectory(MOD_ROOT, new LinkOption[0])) {
            initChickenConfigs.copyFiles(Paths.get(MOD_ROOT.toString(), dataPath), targetPath);
        }
    }

    private static void copyFiles(Path sourcePath, Path targetPath) {
        try (Stream<Path> sourceStream = Files.walk(sourcePath, new FileVisitOption[0]);){
            sourceStream.filter(files -> files.getFileName().toString().endsWith(".json")).forEach(file -> {
                File targetFile = new File(Paths.get(targetPath.toString(), file.getFileName().toString()).toString());
                try {
                    Files.copy(file, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

